%{
This example simulates the kinetics of precipitation of Al3Sc from an 
FCC_A1 solution phase and shows some results, with minimally required 
settings. Default values are used for unspecified settings.
%}

session = tc_toolbox.TCToolbox();

[filepath, name, ext] = fileparts(mfilename("fullpath"));
session.set_cache_folder(name + "_cache");

tc_system = session...
              .select_thermodynamic_and_kinetic_databases_with_elements(...
                "ALDEMO", "MALDEMO", ["Al", "Sc"]).get_system();

precipitation = tc_system.with_isothermal_precipitation_calculation();
precipitation.set_composition("Sc", 0.18);
precipitation.set_temperature(623.15);
precipitation.set_simulation_time(1e5);
precipitation.with_matrix_phase(...
                tc_toolbox.precipitation.MatrixPhase("FCC_A1")...
             .add_precipitate_phase(...
                tc_toolbox.precipitation.PrecipitatePhase("AL3SC")));

precipitation_result = precipitation.calculate();

[time, meanRadius] = precipitation_result.get_mean_radius_of("AL3SC");

loglog(time, meanRadius)
title("Al3Sc precipitation")
xlabel("Time [s]")
ylabel("Mean radius [m]")

