%{
This example shows how to use the License logic in TC-Toolbox for MATLAB.
%}


function ret=print_info()
    % Prints information about the currently activated license.
    
    session = tc_toolbox.TCToolbox();
    license_manager = session.get_license_manager();
    disp("License Information:")
    disp(license_manager.get_info())
end

function ret=activate_online()
    % Activate the license using provided user credentials over the internet.
    % This requires a valid username and password.
    % After activation, the updated license information will be displayed.
    
    session = tc_toolbox.TCToolbox();

    usr = input("User:", 's');  % Note: 's' is used to take string input
    password = input("Password:", 's');  % Note: 's' is used to take string input

    license_manager = session.get_license_manager();
    license_manager.activate(usr, password);
    license_manager.get_info()
end

function ret=create_offline_activation_file()
    % Create an offline activation file in the supplied directory. It is used to activate the license on a machine that does not have internet access.
    % The file is created using user credentials. This is the first step to activate an offline license.
    %
    % Copy that file to a computer with internet access and go to the website https://offline.licensespring.com/. Upload the file as instructed. You will 
    % then get an offline activation file to download. Copy that file to the offline computer and perform activate_offline()
    
    session = tc_toolbox.TCToolbox();

    usr = input("User:", 's');  % Note: 's' is used to take string input
    password = input("Password:", 's');  % Note: 's' is used to take string input
    
    offline_file_directory = pwd;

    license_manager = session.get_license_manager();
    license_manager.create_offline_activation_file(usr, password, offline_file_directory);
    disp("Offline activation file created")
end

function ret=activate_offline()
    % Activate an offline license using the offline activation file (see create_offline_activation_file()).
    
    session = tc_toolbox.TCToolbox();

    usr = input("User:", 's');  % Note: 's' is used to take string input
    password = input("Password:", 's');  % Note: 's' is used to take string input

    license_manager = session.get_license_manager();
    offline_file_directory = pwd;
    license_manager.activate_offline(usr, password, offline_file_directory);

    disp("License Information:")
    disp(license_manager.get_info())
end

function ret=use_proxy()
    % Demonstrates how to use proxy settings for the LicenseManager.
    % This function showcases the `proxy_settings_set` method for configuring
    % proxy settings when working with the license.

    session = tc_toolbox.TCToolbox(); 
    license_manager = session.get_license_manager();

    proxy = 'http://proxy.example.com';
    port = 8080;
    username = 'your_username';
    password = 'your_password';

    license_manager.proxy_settings_set(proxy, port, username, password);
    disp("Proxy configuration is complete.");

    % Remove (reset) proxy configuration
    % license_manager.proxy_settings_remove();
    % disp("Proxy settings have been removed.");
end


function ret=update_license()
    % Update the current license to its latest state.
    % This is usually done to refresh the license information and ensure it is up-to-date.
    % Can not be performed with an offline license.
    
    session = tc_toolbox.TCToolbox();
    license_manager = session.get_license_manager();
    license_manager.update();
    disp("License Information:")
    disp(license_manager.get_info())
end

function ret=deactivate_license()
    % Deactivate the currently active license.

    % This is typically done when you no longer need the license on this machine or want to activate it elsewhere.

    % If you are using an offline license, this will create an offline deactivation file, which is used to deactivate the license on a machine without internet access.
    % Copy that file to a computer with internet access and go to the website https://offline.licensespring.com/. 
    % Upload the file as instructed. The license will then be properly deactivated.

    % An online license will be directly deactivated with this function.
    
    session = tc_toolbox.TCToolbox();
    license_manager = session.get_license_manager();
    license_manager.deactivate();
    disp("License Information:")
    disp(license_manager.get_info())
end

function ret=deactivate_offline_license()
    % Create an offline deactivation file, which is used to deactivate the license on a machine without internet access.

    % Copy that file to a computer with internet access and go to the website https://offline.licensespring.com/. 

    % Upload the file as instructed. The license will then be properly deactivated.
    
    session = tc_toolbox.TCToolbox();
    license_manager = session.get_license_manager();
    offline_file_directory = pwd
    license_manager.deactivate_offline(offline_file_directory);
end

% Note: If your system is behind a proxy, you must call this function and set up
%       the proxy settings before invoking other functions that require network
%       connectivity (e.g., activate_online, update_license, deactivate_license).

%use_proxy()

%print_info()
activate_online()
%create_offline_activation_file()
%activate_offline()
%deactivate_license()
%deactivate_offline_license
