%{
Diffusion with a Moving Boundary between a Ferrite and Austenite Region

This example simulates diffusion including a moving boundary between a ferrite and austenite 
region in an Fe-C steel. Initially the C-concentration is constant in each region, with a step
at the boundary. All units are in wt-%.

The example uses a minimum number of required settings. Default values are used for any 
unspecified settings.
%}

session = tc_toolbox.TCToolbox();
[filepath, name, ext] = fileparts(mfilename("fullpath"));
session.set_cache_folder(name + "_cache");

tc_system = session...
            .select_thermodynamic_and_kinetic_databases_with_elements("FEDEMO", "MFEDEMO", ["Fe", "C"])...
            .without_default_phases()...
            .select_phase("FCC_A1")...
            .select_phase("BCC_A2")...
            .get_system();

calculator = tc_system...
                .with_isothermal_diffusion_calculation()...
                .set_temperature(1050.0)...
                .set_simulation_time(30*3600)...
                .add_region(tc_toolbox.diffusion.Region("Ferrite")...
                    .set_width(1.0E-9)...
                    .with_grid(tc_toolbox.diffusion.CalculatedGrid.automatic())...
                    .with_composition_profile(tc_toolbox.diffusion.CompositionProfile()...
                        .add("C", tc_toolbox.diffusion.ElementProfile.constant(0.01)))...
                    .add_phase("BCC_A2"))...
                .add_region(tc_toolbox.diffusion.Region("Austenite")...
                    .set_width(0.002)...
                    .with_grid(tc_toolbox.diffusion.CalculatedGrid.automatic())...
                    .with_composition_profile(tc_toolbox.diffusion.CompositionProfile()...
                        .add("C", tc_toolbox.diffusion.ElementProfile.constant(0.15)))...
                    .add_phase("FCC_A1"));

result = calculator.calculate();

[time, width_of_ferrite] = result.get_width_of_region("Ferrite");

plot(time, width_of_ferrite);
title("Width of the Ferrite region");
xlabel("Time [s]");
ylabel("Width of Ferrite [m]");
